/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaUserdata;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHelpers;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.debug.ObjectName;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;

public final class ErrorFactory {
    private ErrorFactory() {
    }

    public static LuaString typeName(LuaValue value) {
        LuaValue luaValue;
        LuaTable metatable;
        if ((value instanceof LuaTable || value instanceof LuaUserdata) && (metatable = value.getMetatable(null)) != null && (luaValue = metatable.rawget(Constants.NAME)) instanceof LuaString) {
            LuaString s = (LuaString)luaValue;
            return s;
        }
        return value.luaTypeName();
    }

    public static LuaError argError(LuaValue value, String expected) {
        return new LuaError(new Buffer(32).append("bad argument (").append(expected).append(" expected, got ").append(ErrorFactory.typeName(value)).append(")").toLuaString());
    }

    public static LuaError argError(int iarg, String msg) {
        return new LuaError("bad argument #" + iarg + " (" + msg + ")");
    }

    public static LuaError typeError(LuaValue value, String expected) {
        return new LuaError(new Buffer(32).append(expected).append(" expected, got ").append(ErrorFactory.typeName(value)).toLuaString());
    }

    public static LuaError operandError(LuaState state, LuaValue operand, String verb, int stack) {
        LuaFunction luaFunction;
        DebugFrame info;
        ObjectName kind = null;
        if (stack >= 0 && (info = DebugState.get(state).getStack()) != null && (luaFunction = info.func) instanceof LuaClosure) {
            LuaClosure closure = (LuaClosure)luaFunction;
            if (stack < closure.getPrototype().maxStackSize) {
                kind = DebugHelpers.getObjectName(info, stack);
            }
        }
        if (kind != null) {
            return new LuaError(new Buffer(32).append("attempt to ").append(verb).append(" ").append(kind.what()).append(" '").append(kind.name()).append("' (a ").append(ErrorFactory.typeName(operand)).append(" value)").toLuaString());
        }
        return new LuaError(new Buffer(32).append("attempt to ").append(verb).append(" a ").append(ErrorFactory.typeName(operand)).append(" value").toLuaString());
    }

    public static LuaError compareError(LuaValue lhs, LuaValue rhs) {
        LuaString rhsType;
        LuaString lhsType = ErrorFactory.typeName(lhs);
        if (lhsType.equals((Object)(rhsType = ErrorFactory.typeName(rhs)))) {
            return new LuaError(new Buffer().append("attempt to compare two ").append(lhsType).append(" values").toLuaString());
        }
        return new LuaError(new Buffer().append("attempt to compare ").append(lhsType).append(" with ").append(rhsType).toLuaString());
    }
}

